<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/producto_variacion.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_producto_variacion']) ||
    !isset($_POST['id_usuario'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_producto_variacion = $_POST['id_producto_variacion'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('producto_variacion', $id_producto_variacion));

$producto_variacion = ProductoVariacion::mdlDeleteProductoVariacion($id_producto_variacion);

if (!$producto_variacion) {
    $response['response'] = 'error';
    $response['data'] = 'No se eliminó el producto_variacion';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('delete', 'producto_variacion', $id_producto_variacion, $id_usuario, $valor_anterior);

// Verificamos si al borrar esta variacion, el producto padre ya no tiene variaciones
$data = json_decode($valor_anterior, true);
$id_producto_padre = $data['id_producto_padre'];
$productos_variaciones = ProductoVariacion::mdlGetProductoVariacionByIdProductoPadre($id_producto_padre);
if (count($productos_variaciones) == 1) {
    $producto_variacion = ProductoVariacion::mdlDeleteProductoVariacion($productos_variaciones[0]['id_producto_variacion']);
    ModeloHistory::mdlAddNewRegister('delete', 'producto_variacion', $productos_variaciones[0]['id_producto_variacion'], $id_usuario, $valor_anterior);
}

$response['response'] = 'success';
$response['data'] = $producto_variacion;

echo json_encode($response);
