<?php

error_reporting(E_ALL);
error_reporting(-1);
ini_set('error_reporting', E_ALL);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/producto_variacion.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';

$response = array();

// 1. Debemos agregar la variante a un producto, por lo que necesitamos el id del producto, el de la variante y el tipo de variación
if (!isset(
    $_POST['id_usuario'],
    $_POST['id_producto_padre'],
    $_POST['id_producto'],
    $_POST['id_tipo_variacion'],
    $_POST['atributo_variacion']
)) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

// 2. VALIDAR SI EL USUARIO EXISTE
if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_producto_padre = $_POST['id_producto_padre'];
$id_producto = $_POST['id_producto'];
$id_tipo_variacion = $_POST['id_tipo_variacion'];
$atributo_variacion = $_POST['atributo_variacion'];
$valor_atributo_variacion = 
    (!isset($_POST['valor_atributo_variacion']) || $_POST['valor_atributo_variacion'] == '') ? null : $_POST['valor_atributo_variacion'];

// 3. AGREGAR LA VARIANTE DE PRODUCTO
$id_producto_variacion = ProductoVariacion::mdlAddVarianteProductoById($id_producto, $id_producto_padre, $id_tipo_variacion, $atributo_variacion, $valor_atributo_variacion);

// Si ocurrio un error al agregar, retornar error
if (!$id_producto) {
    $response['response'] = 'error';
    $response['message'] = 'Error al agregar la variación de producto en la base de datos';
    echo json_encode($response);
    return;
}

// 4. Agregamos todo al historial
ModeloHistory::mdlAddNewRegister('create', 'producto_variacion', $id_producto, $id_usuario, NULL);

$response['response'] = 'success';
$response['message'] = 'Variación de producto agregado correctamente';
$response['id_producto_variacion'] = $id_producto_variacion;
echo json_encode($response);