<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

require '../../modelo/producto_orden.php';
require '../../modelo/producto.php';
require '../usuario/decodeUsuario.php';

$response = array();
$productos_orden = array();

$url_servidor = Environment::getUrlServidor();

if (
    !isset($_POST['id_usuario'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$producto_orden = ProductoOrden::mdlGetProductoOrdenById($id_usuario);

if (!$producto_orden) {
    $response['response'] = 'error';
    $response['data'] = 'No se encontró el producto de la orden';
    echo json_encode($response);
    return;
}

$id_orden = 0;

$fecha_actual = new DateTime(date('Y-m-d H:i:s'));

$productos_aux = array();
$productos = array();

foreach ($producto_orden as $key => $value) {
    // Buscas cual es la fecha de compra y tiempo de garantia
    $producto = Producto::mdlGetProductoById($value['id_producto']);
    $fecha_actual = new DateTime(date('Y-m-d H:i:s'));
    $fecha_compra = new DateTime($value['fecha_alta']);
    $tiempo_garantia = $producto['tiempo_garantia'];

    switch($tiempo_garantia) {
        case 1:
            $fecha_compra->modify('+1 year');
            break;

        case 2:
            $fecha_compra->modify('+2 year');
            break;

        case 3:
            $fecha_compra->modify('+3 year');
            break;

        default:
            break;
    }

    if($fecha_actual < $fecha_compra) {
        $productos[] = array(
            'producto' => $producto,
            'id_orden' => $value['id_orden'],
            'id_producto_orden' => $value['id_producto_orden'],
            'numero_orden' => $value['numero_orden'],
            'fecha_compra' => $value['fecha_alta'],
            'numero_serie_equipo' => $value['numero_serie_equipo'],
        );
        continue;
    }

    $productos[] = array(
        'producto' => $producto,
        'id_orden' => $value['id_orden'],
        'id_producto_orden' => $value['id_producto_orden'],
        'numero_orden' => $value['numero_orden'],
        'fecha_compra' => $value['fecha_alta'],
        'numero_serie_equipo' => $value['numero_serie_equipo'],
    );

}

foreach ($productos as $key => $value) {
    $imagenes = json_decode($value['producto']['imagenes']);
    $productos[$key]['url_imagen'] = $url_servidor . $imagenes[0]->url;
}

$response['response'] = 'success';
$response['data'] = $productos;
echo json_encode($response);