<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/producto.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['imagenes']) ||
    !isset($_POST['id_producto'])
) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

// Las imagenes vienen de un stringificado JSON, ya con el nuevo orden
// por lo tanto no se debe hacer un json_decode()
$imagenes = $_POST['imagenes'];
$id_producto = $_POST['id_producto'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('producto', $id_producto));

$update = Producto::updateImagenesById($id_producto, $imagenes);

if (!$update) {
    $response['response'] = 'error';
    $response['message'] = 'No se pudo actualizar el orden de las imágenes de producto';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'producto', $producto, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = $imagen;
echo json_encode($response);
