<?php

error_reporting(E_ALL);
error_reporting(-1);
ini_set('error_reporting', E_ALL);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/producto.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['id_producto']) ||
    !isset($_POST['descripcion'])
) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);
if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_producto = $_POST['id_producto'];
$descripcion = $_POST['descripcion'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('producto', $id_producto));

$updated = Producto::updateDescripcionById($id_producto, $descripcion);

if (!$updated) {
    $response['response'] = 'error';
    $response['message'] = 'No hay cambios por aplicar';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'producto', $id_producto, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['message'] = 'Descripción actualizada correctamente';
echo json_encode($response);