<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/odoo_inventario.php';
require '../../modelo/almacenes_odoo.php';
require '../../modelo/producto.php';
require '../../modelo/producto_variacion.php';

$response = array();

if (!isset($_POST['id_producto_odoo'])) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

// 1. Metemos el id que queremos consultar a un array
$id_producto_odoo = $_POST['id_producto_odoo'];
$product_ids = [];
$product_ids[] = intval($id_producto_odoo);

// 2. Obtenemos todos los almacenes que queremos consultar
$almacenes_odoo = AlmacenesOdoo::mdlGetIdAlmacenesOdoo();

// 3. Consultamos los almacenes y vamos agregando su stock y nombre a un array
$almacenes = [];
foreach ($almacenes_odoo as $almacen) {
    // Siempre limpiar el almacen antes de consultar
    $warehouse_ids = [];

    $warehouse_ids[] = intval($almacen['id_odoo']);
    $stocks = OdooInventario::getGlobalStock($product_ids, $warehouse_ids);
    $almacenes[] = [
        'nombre_almacen' => $almacen['nombre_almacen'],
        'codigo_almacen' => $almacen['codigo_almacen'],
        'stock' => $stocks[0]['free_qty']
    ];
}

$response['response'] = 'success';
$response['data'] = $almacenes;
echo json_encode($response);
