<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/producto.php';
require '../../modelo/wishlist.php';
require '../../modelo/precio.php';
require '../../modelo/odoo_producto.php';
require '../../modelo/odoo_lista_precio.php';
require '../../modelo/producto_variacion.php';
require '../usuario/decodeUsuario.php';

$productosRecomendados = Producto::mdlGetProductosRecomendados();
$productos = array();
$response = array();

if (!$productosRecomendados) {
    $response['response'] = 'error';
    $response['data'] = 'No se encontraron productos recomendados';
    echo json_encode($response);
    return;
}
$productos_variacion_padre = array();

foreach ($productosRecomendados as $key_variaciones => $producto) {
    $id_producto = $producto['id_producto'];

    $producto_variacion = ProductoVariacion::mdlGetProductoVariacionByIdProducto($id_producto);
    if (($producto_variacion === false) || ($producto_variacion['id_producto'] === $producto_variacion['id_producto_padre'])) {
        $productos_variacion_padre[$key_variaciones] = $producto;
    }
}

$id_usuario = isset($_POST['id_usuario']) ? DecodeUser::handlePostUsuario($_POST['id_usuario']) : null;

$aux = 0;

foreach ($productos_variacion_padre as $producto) {
    $productos[$aux] = $producto;

    $id_producto = $producto['id_producto'];

    $precio_regular = Precio::mdlGetPrecioById($producto['id_precio']);

    $productos[$aux]['precio']['id_precio_regular'] = $producto['id_precio'];
    $productos[$aux]['precio']['precio_regular'] = $precio_regular['precio'];
    $productos[$aux]['precio']['precio_descuento'] = null;

    if ($producto['id_precio_descuento'] !== null) {
        $precio_descuento = Precio::mdlGetPrecioById($producto['id_precio_descuento']);

        $productos[$aux]['precio']['id_precio_descuento'] = $producto['id_precio_descuento'];
        $productos[$aux]['precio']['precio_descuento'] = $precio_descuento['precio'];

        $procentaje_descuento = 100 - ($productos[$aux]['precio']['precio_descuento'] * 100) / $productos[$aux]['precio']['precio_regular'];

        $productos[$aux]['precio']['descuento_porcentaje'] = ceil($procentaje_descuento);
    }

    $imagenes = json_decode($producto['imagenes']);
    $imagenes_url = array();
    $url_servidor = Environment::getUrlServidor();

    foreach ($imagenes as $key_imagen => $imagen) {
        $imagenes_url[$key_imagen]['id_imagen'] = $imagen->id;
        $imagenes_url[$key_imagen]['url_imagen'] = $url_servidor . $imagen->url;
    }
    
    $productos[$aux]['imagenes'] = $imagenes_url;

    $calificacion = Producto::mdlGetCalificacionesProducto($id_producto);
    $productos[$aux]['total_calificaciones'] = $calificacion['total_calificaciones'];
    $productos[$aux]['promedio'] = $calificacion['promedio_estrellas'];

    $productos[$aux]['wishlist'] = false;

    $productos[$aux]['wishlist'] = $id_usuario !== null && Wishlist::mdlVerificarExistenciaWishlist($id_usuario, $id_producto);

    $variaciones = ProductoVariacion::mdlGetProductoVariacionByIdProductoPadre($id_producto);
    $productos[$aux]['variaciones'] = $variaciones;

    $aux++;
}

$response['response'] = 'success';
$response['data'] = $productos;
echo json_encode($response);
