<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

error_reporting(E_ALL);
error_reporting(-1);
ini_set('error_reporting', E_ALL);

require '../../modelo/environment.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/orden.php';
require '../../modelo/odoo_producto.php';
require '../../modelo/producto.php';
require './producto.controlador.php';

const LIMITE_DE_PRODUCTOS_POR_PAGINA = 30;

$response = array();
$url_servidor = Environment::getUrlServidor();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['numero_pagina']) ||
    !isset($_POST['termino_busqueda'])
) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);
if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

// 1. Obtenemos los productos de Odoo con el tag de versaprink con un límite de 15
$numero_pagina = ($_POST['numero_pagina'] - 1);
$offset = $numero_pagina * LIMITE_DE_PRODUCTOS_POR_PAGINA;
$termino_busqueda = ($_POST['termino_busqueda'] == "" || $_POST['termino_busqueda'] == null) ? NULL : $_POST['termino_busqueda'];

$tag_id = OdooProducto::getProductTagId('versaprink');
// $productos = OdooProducto::getProductosOdooLimit($offset, LIMITE_DE_PRODUCTOS_POR_PAGINA, $tag_id);
$productos = OdooProducto::searchProductoPorTerminoBusquedaLimit($termino_busqueda, $tag_id, $offset, LIMITE_DE_PRODUCTOS_POR_PAGINA);
$total_productos = OdooProducto::searchProductoPorTerminoBusquedaTotal($termino_busqueda, $tag_id);

if (!$productos) {
    $response['response'] = 'error';
    $response['message'] = 'No se encontraron productos';
    echo json_encode($response);
    return;
}

// 2. Obtenemos los productos que ya están dados de alta en la base de datos
$productos_odoo = Producto::mdlGetAllProductosOdoo();

// 3. Verificamos cuáles productos de Odoo ya están en los productos de la base de datos, y los marcamos como 'agregado'
$productos = ControladorProducto::ctrVerificarProductosYaVinculados($productos, $productos_odoo);

// 4. Le agregamos el costo del IVA al producto para mostrarlo
$productos = ControladorProducto::ctrAumentarCostoIVA($productos);


$response['response'] = 'success';
$response['data'] = array(
    "productos" => $productos,
    "total_productos" => $total_productos,
    "limite" => LIMITE_DE_PRODUCTOS_POR_PAGINA,
);

echo json_encode($response);
