<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/producto.php';
require '../../modelo/wishlist.php';
require '../../modelo/precio.php';
require '../../modelo/odoo_producto.php';
require '../../modelo/odoo_lista_precio.php';
require '../../modelo/subcategoria.php';
require '../../modelo/producto_variacion.php';
require '../usuario/decodeUsuario.php';

$response = array();
$filtros = array();

if (
    !isset($_POST['subcategoria']) ||
    !isset($_POST['categoria'])
) {
    $response['response'] = 'error';
    $response['data'] = 'No se ha enviado la subcategoria';
    echo json_encode($response);
    return;
}

$url_servidor = Environment::getUrlServidor();
$categoria = $_POST['categoria'];
$subcategoria = $_POST['subcategoria'];
$order = (isset($_POST['order'])) ? $_POST['order'] : 'ASC';

$preciosMaxMin = Producto::mdlGetRangoPreciosBySubCategoria($categoria, $subcategoria);
$filtros['precio_min'] = $preciosMaxMin['precio_min'];
$filtros['precio_max'] = $preciosMaxMin['precio_max'];

if (isset($_POST['fecha'])) {
    $filtros['fecha'] = $_POST['fecha'];
}

if (isset($_POST['precio'])) {
    $filtros['precio'] = $_POST['precio'];
}

if (isset($_POST['precio_max'])) {
    $filtros['precio_max'] = intval($_POST['precio_max']);
}

if (isset($_POST['precio_min'])) {
    $filtros['precio_min'] = intval($_POST['precio_min']);
}

if (isset($_POST['categoria'])) {
    $filtros['categoria'] = $_POST['categoria'];

    // $preciosMaxMin = Producto::mdlGetRangoPreciosBySubcategoria($categoria, $subcategoria);
    // $filtros['precio_min'] = $preciosMaxMin['precio_min'];
    // $filtros['precio_max'] = $preciosMaxMin['precio_max'];
}

if (isset($_POST['proveedor'])) {
    $filtros['proveedor'] = $_POST['proveedor'];
}

$productos = Producto::mdlGetProductosSubCategoriaFiltros($filtros, $categoria, $subcategoria, $order);

if (count($productos) > 0) {
    $productos_variacion_padre = array();

    foreach ($productos as $key_variaciones => $producto) {
        $id_producto = $producto['id_producto'];

        $producto_variacion = ProductoVariacion::mdlGetProductoVariacionByIdProducto($id_producto);

        if (($producto_variacion === false) || ($producto_variacion['id_producto'] === $producto_variacion['id_producto_padre'])) {
            $productos_variacion_padre[$key_variaciones] = $producto;
        }
    }

    // Si no existe al menos un producto padre de esta categoría, no mostrar nadota.
    if (count($productos_variacion_padre) > 0) {

        $id_usuario = isset($_POST['id_usuario']) ? DecodeUser::handlePostUsuario($_POST['id_usuario']) : null;

        $pagina = isset($_POST['pagina']) ? intval($_POST['pagina']) : 1;
        $limite = isset($_POST['limite']) ? intval($_POST['limite']) : 12;

        $total_productos = count($productos_variacion_padre);
        $total_paginas = ceil($total_productos / $limite);

        if ($pagina < 1) {
            $pagina = 1;
        } elseif ($pagina > $total_paginas) {
            $pagina = $total_paginas;
        }

        $offset = ($pagina - 1) * $limite;

        $paginado_productos = array_slice($productos_variacion_padre, $offset, $limite);

        foreach ($paginado_productos as $key => $producto) {
            $id_producto = $producto['id_producto'];

            $precio_regular = Precio::mdlGetPrecioById($producto['id_precio']);

            $paginado_productos[$key]['precio']['id_precio_regular'] = $producto['id_precio'];
            $paginado_productos[$key]['precio']['precio_regular'] = $precio_regular['precio'];
            $paginado_productos[$key]['precio']['precio_descuento'] = null;

            if ($producto['id_precio_descuento'] !== null) {
                $precio_descuento = Precio::mdlGetPrecioById($producto['id_precio_descuento']);

                $paginado_productos[$key]['precio']['id_precio_descuento'] = $producto['id_precio_descuento'];
                $paginado_productos[$key]['precio']['precio_descuento'] = $precio_descuento['precio'];

                $procentaje_descuento = 100 - ($paginado_productos[$key]['precio']['precio_descuento'] * 100) / $paginado_productos[$key]['precio']['precio_regular'];

                $paginado_productos[$key]['precio']['descuento_porcentaje'] = ceil($procentaje_descuento);
            }

            $imagenes = json_decode($producto['imagenes']);
            $imagenes_url = array();

            foreach ($imagenes as $key_imagen => $imagen) {
                $imagenes_url[$key_imagen]['id_imagen'] = $imagen->id;
                $imagenes_url[$key_imagen]['url_imagen'] = $url_servidor . $imagen->url;
            }

            $paginado_productos[$key]['imagenes'] = $imagenes_url;

            $calificacion = Producto::mdlGetCalificacionesProducto($id_producto);
            $paginado_productos[$key]['total_calificaciones'] = $calificacion['total_calificaciones'];
            $paginado_productos[$key]['promedio'] = $calificacion['promedio_estrellas'];

            $paginado_productos[$key]['wishlist'] = false;

            $paginado_productos[$key]['wishlist'] = $id_usuario !== null && Wishlist::mdlVerificarExistenciaWishlist($id_usuario, $id_producto);

            $variaciones = ProductoVariacion::mdlGetProductoVariacionByIdProductoPadre($id_producto);
            $paginado_productos[$key]['variaciones'] = $variaciones;
        }
    } else {
    }

    // $paginado_productos = [];
} else {
    $paginado_productos = [];
    $total_paginas = 0;
    $pagina = 1;
}

// Obtenemos el id de la subcategoría para obtener su información

$subcategoria_info = Subcategoria::mdlGetSubcategoriaByNombres(
    $categoria,
    $subcategoria
);

$subcategoria_info['imagen'] = $url_servidor . $subcategoria_info['imagen'];

$response['response'] = 'success';
$response['subcategoria'] = $subcategoria_info;
$response['data'] = $paginado_productos;
$response['precio_min'] = $preciosMaxMin['precio_min'];
$response['precio_max'] = $preciosMaxMin['precio_max'];
$response['total_paginas'] = $total_paginas;
$response['pagina_actual'] = $pagina;

echo json_encode($response);
