<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/producto.php';
require '../../modelo/producto_categoria.php';
require '../../modelo/producto_variacion.php';
require '../../modelo/environment.php';
require '../../modelo/precio.php';

$response = array();

if (!isset($_POST['id_producto'])) {
    $response['response'] = 'error';
    $response['message'] = 'No se recibió el id del producto';
    echo json_encode($response);
    return;
}

$id_producto = $_POST['id_producto'];

$producto = Producto::mdlGetProductoById($id_producto);

if (!$producto) {
    $response['response'] = 'error';
    $response['message'] = 'No se encontró el producto';
    echo json_encode($response);
    return;
}

// Obtenemos la primer imagen del producto
$producto['url_imagen'] = null;
if (!is_null($producto['imagenes'])) {
    $imagenes = json_decode($producto['imagenes']);
    $imagenes_url = array();
    $url_servidor = Environment::getUrlServidor();
    $producto['url_imagen'] = $url_servidor . $imagenes[0]->url;
}

// Obtenemos la categoria y subcategoria del producto
$categorias = ProductoCategoria::mdlGetCategoriaAndSubcategoriaById($producto['id_producto']);
$producto['id_categoria'] = $categorias['id_categoria'];
$producto['id_subcategoria'] = $categorias['id_subcategoria'];

// Formateo la fecha de creación
$fecha = date($producto['fecha_alta']);
$fechaFormat = strftime("%B %d, %Y", strtotime($fecha));
$producto['fecha_alta'] = $fechaFormat;

// Agregamos la URL a las imagenes
$imagenes = json_decode($producto['imagenes']);
$url_servidor = Environment::getUrlServidor();
foreach ($imagenes as $key => $imagen) {
    $imagenes[$key]->url = $url_servidor . $imagen->url;
}
$producto['imagenes'] = $imagenes;

// Verificamos si tiene variaciones
$id_producto_padre = $id_producto;
$producto_variacion = ProductoVariacion::mdlGetProductoVariacionByIdProductoPadre($id_producto_padre);

if (!$producto_variacion) {
    $producto['variaciones'] = null;
} else {
    $producto['variaciones'] = $producto_variacion;
}

// Verificamos si el producto es el producto padre en las variaciones
$producto['es_padre'] = false;
if ($producto_variacion) {
    foreach ($producto_variacion as $key => $variacion) {
        if ($id_producto == $variacion['id_producto_padre']) {
            $producto['es_padre'] = true;
            break;
        }
    }
}

// Si no es el producto padre, agregamos quien si es el producto padre
if (!$producto['es_padre']) {
    // Consultamos el producto padre con el id_producto actual como hijo
    $producto_padre = ProductoVariacion::mdlGetProductoVariacionByIdProductoHijo($id_producto);
    $producto['sku_producto_padre'] = $producto_padre['sku'];
    $producto['nombre_producto_padre'] = $producto_padre['nombre'];
    $producto['id_producto_padre'] = $producto_padre['id_producto_padre'];
}

// Obtenemos el precio de los productos de variación
if ($producto_variacion) {
    foreach ($producto_variacion as $key => $variacion) {
        $precio = Precio::mdlGetPrecioById($variacion['id_precio']);
        $producto['variaciones'][$key]['precio'] = $precio['precio'];
    }
}

$producto['color_fondo'] = $producto['color_categoria'];

$response['response'] = 'success';
$response['data'] = $producto;

echo json_encode($response);
