<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/producto.php';
require '../../modelo/pregunta.php';
require '../../modelo/calificacion_producto.php';
require '../../modelo/producto_variacion.php';
require '../../modelo/precio.php';
require '../../modelo/wishlist.php';
require '../../modelo/odoo_producto.php';
require '../../modelo/odoo_lista_precio.php';
require '../usuario/decodeUsuario.php';

function getProductoDetalle($producto, $id_usuario)
{
    $producto_odoo = OdooProducto::searchProduct($producto['id_producto_odoo']);

    $producto['precio']['id_precio_regular'] = $producto['id_precio'];
    $producto['precio']['precio_regular'] = $producto_odoo[0]['list_price'];
    $producto['precio']['precio_descuento'] = null;

    $vigencia_descuento = Precio::mdlGetPrecioById($producto['id_precio_descuento'])['fecha_baja'];

    if ($producto['id_precio_descuento'] !== null && ($vigencia_descuento >= date('Y-m-d') || $vigencia_descuento === null)) {
        $lista_precios = OdooListaPrecio::getPriceRulesByProductId(intval($producto['id_producto_odoo']));
        $precio_descuento = Precio::mdlGetPrecioById($producto['id_precio_descuento']);
        $lista_precios_nombre = $precio_descuento['etiqueta'];

        $filtrar_precios = array();

        foreach ($lista_precios as $price) {
            if ($price['pricelist_id'][1] == $lista_precios_nombre && $price['product_tmpl_id'][0] == $producto['id_producto_odoo']) {
                $filtrar_precios = $price;
                break;
            }
        }

        $producto['precio']['id_precio_descuento'] = $producto['id_precio_descuento'];
        $producto['precio']['precio_descuento'] = $filtrar_precios['fixed_price'];

        $procentaje_descuento = 100 - ($producto['precio']['precio_descuento'] * 100) / $producto['precio']['precio_regular'];
        $producto['precio']['descuento_porcentaje'] = ceil($procentaje_descuento);
    }

    $imagenes = json_decode($producto['imagenes']);
    $imagenes_url = array();
    $url_servidor = Environment::getUrlServidor();

    foreach ($imagenes as $key_imagen => $imagen) {
        $imagenes_url[$key_imagen]['id_imagen'] = $imagen->id;
        $imagenes_url[$key_imagen]['url_imagen'] = $url_servidor . $imagen->url;
    }

    $producto['imagenes'] = $imagenes_url;

    $producto['stock'] = $producto_odoo[0]['virtual_available'];

    $calificacion = Producto::mdlGetCalificacionesProducto($producto['id_producto']);

    $producto['total_calificaciones'] = $calificacion['total_calificaciones'];
    $producto['promedio'] = number_format($calificacion['promedio_estrellas'], 2);

    $producto['wishlist'] = $id_usuario !== null && Wishlist::mdlVerificarExistenciaWishlist($id_usuario, $producto['id_producto']);

    return $producto;
}

if (!isset($_POST['url_pagina'])) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$url_pagina = $_POST['url_pagina'];

$id_usuario = isset($_POST['id_usuario']) ? DecodeUser::handlePostUsuario($_POST['id_usuario']) : null;

$producto_inicial = Producto::mdlGetProductoByURL($url_pagina);

if (!$producto_inicial) {
    $response['response'] = 'error';
    $response['data'] = 'No se encontró el producto.';
    echo json_encode($response);
    return;
}

$id_producto = $producto_inicial['id_producto'];

$atributo_variacion = isset($_POST['atributo_variacion']) ? $_POST['atributo_variacion'] : null;
$producto_variaciones = ProductoVariacion::mdlGetProductoVariacionByIdProductoPadre($id_producto, $atributo_variacion);

$producto = getProductoDetalle($producto_inicial, $id_usuario);

if (count($producto_variaciones) > 0) {
    $variaciones = array();
    foreach ($producto_variaciones as $key => $variacion) {
        $producto_aux[$key] = getProductoDetalle(Producto::mdlGetProductoById($variacion['id_producto']), $id_usuario);
        
        $nombre_variacion = $variacion['nombre_variacion'];
        
        $variaciones[$key]['id_tipo_variacion'] = $variacion['id_tipo_variacion'];
        $variaciones[$key]['tipo_variacion'] = $nombre_variacion;
        $variaciones[$key]['nombre'] = $variacion['atributo_variacion'];
        // $variaciones[$key][$nombre_variacion] = $variacion['atributo_variacion'];
        // $variaciones[$key]['nombre'] = $variacion['valor_atributo_variacion'];
        $variaciones[$key][$nombre_variacion] = $variacion['valor_atributo_variacion'];
        
        $variaciones[$key]['id_producto'] = $producto_aux[$key]['id_producto'];
        $variaciones[$key]['stock'] = $producto_aux[$key]['stock'];
        $variaciones[$key]['sku'] = $producto_aux[$key]['sku'];
        $variaciones[$key]['precio'] = $producto_aux[$key]['precio'];
        $variaciones[$key]['imagenes'] = $producto_aux[$key]['imagenes'];
    }
}

$producto['variaciones'] = $variaciones;

$preguntas = Pregunta::mdlGetPreguntaRespuestaByIdProducto($id_producto);

$resenas = CalificacionProducto::mdlGetCalificacionProductosResenasByIdProducto($id_producto);

if ($resenas !== false || $resenas !== null) {
    foreach ($resenas as $key => $resena) {
        $resenas[$key]['foto_perfil'] = Environment::getUrlServidor() . $resena['foto_perfil'];

        if ($resena['imagen_resena'] != null) {
            $imagenes = json_decode($resena['imagen_resena']);
            $imagenes_url = array();
            $url_servidor = Environment::getUrlServidor();

            foreach ($imagenes as $key_imagen => $imagen) {
                $imagenes_url[$key_imagen]['id_imagen'] = $imagen->id;
                $imagenes_url[$key_imagen]['url_imagen'] = $url_servidor . $imagen->url;
            }
        }

        $resenas[$key]['imagen_resena'] = $imagenes_url;
    }
}

Producto::mdlUpdateVisitas($id_producto);

$response['response'] = 'success';
$response['data'] = $producto;
$response['resenas'] = (!$resenas) ? [] : $resenas;
$response['preguntas'] = (!$preguntas) ? [] : $preguntas;
// $response['variaciones'] = (!$variaciones) ? [] : $variaciones;

echo json_encode($response);
