<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/producto.php';
require '../../modelo/precio.php';
require '../../modelo/wishlist.php';
require '../../modelo/producto_variacion.php';
require '../usuario/decodeUsuario.php';

$equiposRecientes = Producto::mdlGetEquiposRecientes();
$response = array();

if (!$equiposRecientes) {
    $response['response'] = 'error';
    $response['data'] = 'No se encontraron equipos agregados recientemente';
    echo json_encode($response);
    return;
}

$id_usuario = isset($_POST['id_usuario']) ? DecodeUser::handlePostUsuario($_POST['id_usuario']) : null;

$productos = array();
$i = 0;

foreach ($equiposRecientes as $key => $producto) {
    $id_producto = $producto['id_producto'];
    // Preguntamos si es un producto de variacion
    $producto_variacion = ProductoVariacion::mdlGetProductoVariacionByIdProducto($id_producto);
    
    if (($producto_variacion === false) || ($producto_variacion['id_producto'] === $producto_variacion['id_producto_padre'])) {
        $precio_regular = Precio::mdlGetPrecioById($producto['id_precio']);
        
        $productos[$i] = $producto;
        $productos[$i]['precio']['id_precio_regular'] = $producto['id_precio'];
        $productos[$i]['precio']['precio_regular'] = $precio_regular['precio'];
        $productos[$i]['precio']['precio_descuento'] = null;

        if ($producto['id_precio_descuento'] !== null) {
            $precio_descuento = Precio::mdlGetPrecioById($producto['id_precio_descuento']);

            $productos[$i]['precio']['id_precio_descuento'] = $producto['id_precio_descuento'];
            $productos[$i]['precio']['precio_descuento'] = $precio_descuento['precio'];

            $procentaje_descuento = 100 - ($productos[$i]['precio']['precio_descuento'] * 100) / $productos[$i]['precio']['precio_regular'];

            $productos[$i]['precio']['descuento_porcentaje'] = ceil($procentaje_descuento);
        }

        $imagenes = json_decode($producto['imagenes']);
        $imagenes_url = array();
        $url_servidor = Environment::getUrlServidor();

        foreach ($imagenes as $key_imagen => $imagen) {
            $imagenes_url[$key_imagen]['id_imagen'] = $imagen->id;
            $imagenes_url[$key_imagen]['url_imagen'] = $url_servidor . $imagen->url;
        }

        $productos[$i]['imagenes'] = $imagenes_url;

        $calificacion = Producto::mdlGetCalificacionesProducto($id_producto);
        $productos[$i]['total_calificaciones'] = $calificacion['total_calificaciones'];
        $productos[$i]['promedio'] = $calificacion['promedio_estrellas'];

        $productos[$i]['wishlist'] = false;

        $productos[$i]['wishlist'] = $id_usuario !== null && Wishlist::mdlVerificarExistenciaWishlist($id_usuario, $id_producto);
        $i++;
    }

}

$response['response'] = 'success';
$response['data'] = $productos;
echo json_encode($response);
