<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

error_reporting(E_ALL);
error_reporting(-1);
ini_set('error_reporting', E_ALL);

require '../../modelo/producto.php';
require '../../modelo/environment.php';

const LIMITE_DE_PRODUCTOS_POR_PAGINA = 20;

$numero_pagina = ($_POST['numero_pagina'] - 1);
$offset = $numero_pagina * LIMITE_DE_PRODUCTOS_POR_PAGINA;

$termino_busqueda = $_POST['termino_busqueda'];
$orderBy = json_decode($_POST['orderBy'], true);
$filters = json_decode($_POST['filters'], true);

$productos = Producto::mdlSearchLimit($filters, $termino_busqueda, $orderBy, $offset, LIMITE_DE_PRODUCTOS_POR_PAGINA);
$total_productos = Producto::mdlSearchTotal($filters, $termino_busqueda);

if (!$productos) {
    $response['response'] = 'error';
    $response['message'] = 'No se encontraron productos';
    echo json_encode($response);
    return;
}

// Obtenemos las ventas totales de todos los productos, nos servirá para el ranking
$ventas_totales_productos = Producto::mdlGetVentasTotalesAllProductos();

$texto_final = "";
foreach ($productos as $key => $producto) {

    if (!is_null($producto['imagenes'])) {
        $imagenes = json_decode($producto['imagenes']);
        $imagenes_url = array();
        $url_servidor = Environment::getUrlServidor();

        $productos[$key]['url_imagen'] = $url_servidor . $imagenes[0]->url;
    }

    $productos[$key]['color_fondo'] = $producto['color_categoria'];
    $productos[$key]['nombre_producto'] = $producto['nombre'];

    $productos[$key]['stock'] = 35;
    $productos[$key]['ranking'] = 1;
    $productos[$key]['precio'] = $producto['precio_producto'];

    // Si es el ultimo producto, no concatenar la coma
    if ($key == count($productos) - 1) {
        $texto_final = $producto['nombre'];
    } else {
        $texto_final = $producto['nombre'] . ", ";
    }

    $fecha = date($producto['fecha_alta']);
    $fechaFormat = strftime("%B %d, %Y", strtotime($fecha));
    $productos[$key]['fecha_alta'] = $fechaFormat;

    // Agregamos el ranking al que pertenece este producto:
    $cantidad_vendida = $producto['cantidad_vendida'];
    $ranking = 1;
    $encontrado = false;

    $id_producto = $producto['id_producto'];
    
    foreach ($ventas_totales_productos as $value) {
        if ($value['id_producto'] == $id_producto) {
            $encontrado = true;
            break;
        }
        $ranking++;
    }

    $productos[$key]['ranking'] = $ranking;
}

$response['response'] = 'success';
$response['data'] = array(
    "productos" => $productos,
    "total_productos" => $total_productos['total'],
    "limite" => LIMITE_DE_PRODUCTOS_POR_PAGINA,
);

echo json_encode($response);
