<?php

error_reporting(E_ALL);
error_reporting(-1);
ini_set('error_reporting', E_ALL);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/producto.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

// VALIDAR SI LOS CAMPOS EXISTEN
if (!isset(
    $_POST['id_usuario'],
    $_POST['id_producto'],
    $_POST['id_imagen'],
)) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

// VALIDAR SI EL USUARIO EXISTE
if (!$id_usuario) {

    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';

    echo json_encode($response);
    return;
}

$id_producto = $_POST['id_producto'];
$id_imagen = $_POST['id_imagen'];

// Debemos obtener todas las imagenes primero
$producto = Producto::mdlGetProductoById($id_producto);

$imagenes = json_decode($producto['imagenes']);

// Al tener todas las imagenes, debemos buscar la imagen que se quiere eliminar y la borramos del arreglo
foreach ($imagenes as $key => $imagen) {
    if ($imagen->id == $id_imagen) {
        unset($imagenes[$key]);
        break;
    }
}

// Guardamos las imagenes nuevamente en el producto, las imagenes debe ser un array
$new_imagenes = json_encode(array_values($imagenes));

// Si el arreglo es vacio, entonces registramos un NULL
if ($new_imagenes == '[]') {
    $new_imagenes = NULL;
}

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('producto', $id_producto));

$updated = Producto::updateImagenesById($id_producto, $new_imagenes);

if (!$updated) {
    $response['response'] = 'error';
    $response['message'] = 'No hay cambios por aplicar';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'producto', $id_producto, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['message'] = 'Imagen eliminada correctamente';
echo json_encode($response);
