<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/pregunta.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

// NECESITAMOS EL id_pregunta, activo y el id del usuario activo
if (
    !isset($_POST['id']) ||
    !isset($_POST['id_pregunta']) ||
    !isset($_POST['activo'])
) {
    echo json_encode([
        'response' => 'error',
        'message' => 'Datos incompletos'
    ]);
    return;
}

$id = DecodeUser::handlePostUsuario($_POST['id']);
if (!$id) {
    echo json_encode([
        'response' => 'error',
        'message' => 'Id del usuario activo incorrecto.'
    ]);
    return;
}

$activo = $_POST['activo'];
$id_pregunta = $_POST['id_pregunta'];
$valor_anterior = json_encode(ModeloGlobal::mdlSelect('pregunta', $id_pregunta));

$pregunta = Pregunta::mdlUpdateEstadoPregunta($id_pregunta, $activo);

if (!$pregunta) {
    echo json_encode([
        'response' => 'error',
        'message' => 'No se pudo actualizar el activo de la pregunta.'
    ]);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'pregunta', $id_pregunta, $id, $valor_anterior);

echo json_encode([
    'response' => 'success',
    'message' => 'Se actualizó correctamente el estado de la pregunta.'
]);
http_response_code(200); // success
