<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/pregunta.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['id_producto']) ||
    !isset($_POST['pregunta'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_producto = $_POST['id_producto'];
$pregunta = $_POST['pregunta'];

$pregunta = Pregunta::mdlAddPregunta($id_usuario, $id_producto, $pregunta);

if (!$pregunta) {
    $response['response'] = 'error';
    $response['data'] = 'No se agregó el historial';
    echo json_encode($response);
    return;
}

$response['response'] = 'success';
$response['data'] = 'Pregunta agregada';
echo json_encode($response);