<?php

require_once '../../modelo/pak2go.php';

// Example usage
// $requestData = array(
//     // "zip_from" => "57210",
//     "zip_from" => "06880",
//     "zip_to" => "06090",
//     "to_neighbornhood" => "Cuauhtémoc",
//     "parcel" => array(
//         "weight" => 4,
//         "height" => 36,
//         "width" => 36,
//         "length" => 47,

//         // "height" => 113,
//         // "width" => 56,
//         // "length" => 51,

//         // "length" => 38*2,
//         // "height" => 29*2,
//         // "width" => 49*2,

//         // "height" => 46.3,
//         // "width" => 59.8,
//         // "length" => 73.3,

//         // "height" => 36,
//         // "width" => 36,
//         // "length" => 47,
//         "type_of" => "box"
//         // "type_of" => "tarima"
//     )
// );

// $response = Pak2Go::checkPrices($requestData);
// echo json_encode($response);

$data = [
    "address_from" => [
        "province" => "Ciudad de México",
        "city" => "Cuauhtémoc",
        "name" => "José Fernando",
        "zip" => "06880",
        "country" => "MX",
        "address1" => "José Toribio Medina 112",
        "company" => "Pak2go",
        "address2" => "Algarín",
        "phone" => "5555555555",
        "email" => "Pak2go@email.com",
        "rfc" => "ABCD900627RCM"
    ],
    "parcels" => [
        [
            "weight" => 3,
            "distance_unit" => "CM",
            "mass_unit" => "KG",
            "height" => 17,
            "width" => 17,
            "length" => 27,
            "contents" => "contenido del paquete",
            "product_code_sat" => "50171832",
            "type_of" => "box"
        ]
    ],
    "address_to" => [
        "deliver_type" => "address",
        "province" => "San Luis Potosí",
        "city" => "Tamazunchale",
        "name" => "José Camacho",
        "zip" => "79966",
        "country" => "MX",
        "address1" => "C29 128",
        "company" => "-",
        "address2" => "Cuajapa Tamán",
        "phone" => "5534080960",
        "email" => "juan@email.com",
        "rfc" => "CAMJ990627RCM",
        "reference" => "Frente a tienda de abarrotes"
    ]
];

$response = Pak2Go::createShipment($data);

if (!$response) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo crear el envío';
    echo json_encode($response);
    return;
}

$ratesObjects = [];

foreach ($response['included'] as $object) {
    if ($object['type'] === 'rates') {
        $ratesObjects[] = $object;
    }
}

echo json_encode("------------------");
echo json_encode($ratesObjects);
echo json_encode("------------------");
return;

$desiredProvider = "PAQUETEXPRESS"; // Specify the provider you are looking for

$desiredRateObject = array_values(array_filter($ratesObjects, function ($rateObject) use ($desiredProvider) {
    return $rateObject['attributes']['provider'] === $desiredProvider;
}));

// echo json_encode("------------------");
// echo json_encode($desiredRateObject);
// echo json_encode("------------------");

// $desiredRateObject now contains the object with the specified provider value

$rate_id = array(
    "rate_id" => $desiredRateObject[0]['id'],
    "label_format" => "pdf",
);

$guide = Pak2Go::generateGuide($rate_id);
echo json_encode($guide);
