<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/orden.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_orden']) ||
    !isset($_POST['id_usuario']) ||
    !isset($_POST['id_direccion_envio']) ||
    !isset($_POST['id_direccion_facturacion']) ||
    !isset($_POST['id_estado_orden']) ||
    !isset($_POST['id_orden_odoo'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_orden = $_POST['id_orden'];
$id_direccion_envio = $_POST['id_direccion_envio'];
$id_direccion_facturacion = $_POST['id_direccion_facturacion'];
$id_estado_orden = $_POST['id_estado_orden'];
$id_orden_odoo = $_POST['id_orden_odoo'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('orden', $id_orden));

$orden = Orden::mdlUpdateOrden($id_orden, $id_usuario, $id_direccion_envio, $id_direccion_facturacion, $id_estado_orden, $id_orden_odoo);

if (!$orden) {
    $response['response'] = 'error';
    $response['data'] = 'No se actualizo la orden';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'orden', $id_orden, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = $orden;

echo json_encode($response);