<?php

error_reporting(E_ALL);
error_reporting(-1);
ini_set('error_reporting', E_ALL);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/usuario.php';
require '../../modelo/carrito.php';
require '../usuario/decodeUsuario.php';

require_once __DIR__ . '/../../vendor/autoload.php';

use Openpay\Data\Openpay;

Openpay::setId('mleuoellwbejhbo7jxmt');
Openpay::setApiKey('sk_a73e463609cd4ecf9ec66c508e8fc0e9');
Openpay::setProductionMode(false);

$openpay = Openpay::getInstance(
    'mleuoellwbejhbo7jxmt',
    'sk_a73e463609cd4ecf9ec66c508e8fc0e9',
    'MX'
);

// Obtenemos los datos del usuario
$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);
if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

// Obtenemos los campos de POST en una variable
// $id_usuario = $_POST["id_usuario"];
$token_id = $_POST["token_id"];
$precio_envio = $_POST["precio_envio"];
// $description = $_POST["description"];
// $use_card_points = $_POST["use_card_points"];
$device_session_id = $_POST["device_session_id"];

$is_cita_soporte = isset($_POST["is_cita_soporte"]) ? $_POST["is_cita_soporte"] : null;

$usuario = Usuario::mdlGetUsuarioById($id_usuario);

$name = $usuario['nombre'];
$last_name = $usuario['apellido_paterno'];
$phone_number = $usuario['celular'];
$email = $usuario['correo'];
$id_cliente_openpay = $usuario['id_cliente_openpay'];

if (is_null($id_cliente_openpay)) {

    $customer = array(
        'name' => $name,
        'last_name' => $last_name,
        'phone_number' => $phone_number,
        'email' => $email,
    );

    $customerId = $openpay->customers->add($customer);
    Usuario::mdlUpdateCustomerIdOpenpay($id_usuario, $customerId->id);

    $id_cliente_openpay = $customerId->id;
}

//Costo de la cita de soporte
$subtotal = 300;

if(is_null($is_cita_soporte)) {
    // Obtener el total de la orden
    $carrito = Carrito::mdlGetCarritoByIdUsuario($id_usuario);
    $subtotal = 0;
    foreach ($carrito as $key => $value) {
        $suma = $value['cantidad'] * $value['precio'];
        $subtotal += $suma;
    }

    // Sumamos el costo de envío
    $subtotal += floatval($precio_envio);
}
// Redondear el subtotal hasta maximo 2 decimales
$subtotal = number_format($subtotal, 2, '.', '');

$chargeData = array(
    'source_id' => $token_id,
    'method' => 'card',
    'amount' => strval($subtotal),
    'currency' => 'MXN',
    'description' => 'Cargo inicial a mi cuenta',
    // 'order_id' => 'ORDEN-0001',
    'device_session_id' => $device_session_id,
);

// print_r($chargeData);

try {
    $customer_payment = $openpay->customers->get($id_cliente_openpay);
    $charge = $customer_payment->charges->create($chargeData);
    
    if ($charge->status != 'completed') {
        $response['response'] = 'error';
        $response['message'] = 'No se pudo realizar el cargo';
        echo json_encode($response);
    } 

    $response['response'] = 'success';
    $response['data'] = $charge->id;
    echo json_encode($response);
} catch (Exception $e) {
    // echo 'Caught exception: ',  $e->getMessage(), "\n";
    $response['response'] = 'error';
    $response['message'] = $e->getMessage();
    echo json_encode($response);
}
