<?php

error_reporting(E_ALL);
error_reporting(-1);
ini_set('error_reporting', E_ALL);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../usuario/decodeUsuario.php';
require '../../modelo/carrito.php';
require '../envio/costo_envio.php';
require '../envio/costo_paqueteria.php';
require '../../modelo/paqueteria.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['cp'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$cp = $_POST['cp'];
$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);
$productos = Carrito::mdlGetCarritoByIdUsuario($id_usuario);

$paqueterias = Envio::getPaqueteriasCheckout($cp, $productos);

if (!$paqueterias) {
    $response['response'] = 'error';
    $response['data'] = 'No se encontraron paqueterias';
    echo json_encode($response);
    return;
}

$envio = array();
$i = 0;

foreach ($paqueterias as $key => $value) {
    foreach ($value as $paqueteria => $costo) {
        $envio[$i]['paqueteria'] = $paqueteria;
        $envio[$i]['precio'] = $costo;
        $id_envio = Paqueteria::mdlGetPaqueteriaByNombre($paqueteria);
        $envio[$key]['id_paqueteria'] = $id_envio['id_paqueteria'];
    }

    $i++;
}

$response['response'] = 'success';
$response['data'] = $envio;

echo json_encode($response);
