<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require '../../modelo/orden.php';
require '../../modelo/odoo_orden_venta.php';
require '../../modelo/environment.php';
require '../usuario/decodeUsuario.php';

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['id_orden'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}


$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}


$id_orden = $_POST['id_orden'];
$id_orden_odoo = Orden::mdlGetIdOrdenOdooById($id_orden)['id_orden_odoo'];

$data_odoo = OdooOrdenVenta::verificarYObtenerLogFactura($id_orden_odoo);
$factura = $data_odoo['facturas'][0];
$factura['url_factura'] = $data_odoo['url_factura'];

$response['response'] = 'success';
$response['data'] = $factura;
echo json_encode($response);
