<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require '../../modelo/orden.php';
require '../../modelo/producto_orden.php';
require '../../modelo/direccion_envio.php';
require '../../modelo/direccion_facturacion.php';
require '../../modelo/calificacion_producto.php';
require '../../modelo/producto_variacion.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/guia_envio_orden.php';
require '../../modelo/guia_envio_producto.php';
require '../../modelo/guia_envio_zona_extendida_producto.php';

$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['numero_orden'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$numero_orden = $_POST['numero_orden'];

$orden = Orden::mdlGetDetallesOrdenByNumeroOrden($id_usuario, $numero_orden);

if (!$orden) {
    $response['response'] = 'error';
    $response['data'] = 'No se encontró la orden';
    echo json_encode($response);
    return;
}

$id_orden = $orden['id_orden'];

if ($orden['id_direccion_envio'] !== false || $orden['id_direccion_envio'] !== null) {
    $direccion_envio = DireccionEnvio::mdlGetDireccionById($id_usuario, $orden['id_direccion_envio']);

    if (!$direccion_envio) {
        $response['response'] = 'error';
        $response['data'] = 'No se encontró la dirección de envío';
        echo json_encode($response);
        return;
    }

    $orden['direccion_envio'] = $direccion_envio;
}

$orden['direccion_facturacion'] = [];

if ($orden['id_direccion_facturacion'] != false || $orden['id_direccion_facturacion'] != null) {
    $direccion_facturacion = DireccionFacturacion::mdlGetDireccionFacturacionById($id_usuario, $orden['id_direccion_facturacion']);

    $orden['direccion_facturacion'] = $direccion_facturacion;
}

$productos = ProductoOrden::mdlGetProductoOrdenByIdOrden($id_orden);

if (!$productos) {
    $response['response'] = 'error';
    $response['data'] = 'No se encontraron productos';
    echo json_encode($response);
    return;
}

$total_precio_productos = 0;

foreach ($productos as $key => $producto) {

    $imagenes = json_decode($producto['imagenes']);
    $url_servidor = Environment::getUrlServidor();

    $productos[$key]['url_imagen'] = $url_servidor . $imagenes[0]->url;
    unset($productos[$key]['imagenes']);
    unset($productos[$key]['etiqueta']);

    $producto_variacion = ProductoVariacion::mdlGetProductoVariacionByIdProducto($producto['id_producto']);

    $total_precio_productos += (number_format((float)$producto['precio'], 2, '.', '') * $producto['cantidad']);

    $productos[$key]['variacion'] = [];

    if ($producto_variacion) {
        $variaciones = array();

        $nombre_variacion = $producto_variacion['nombre_variacion'];;
        
        $variaciones['id_tipo_variacion'] = $producto_variacion['id_tipo_variacion'];
        $variaciones['tipo_variacion'] = $nombre_variacion;
        $variaciones['nombre'] = $producto_variacion['atributo_variacion'];
        // $variaciones[$nombre_variacion] = $producto_variacion['atributo_variacion'];
        // $variaciones['nombre'] = $producto_variacion['valor_atributo_variacion'];
        $variaciones[$nombre_variacion] = $producto_variacion['valor_atributo_variacion'];

        $productos[$key]['variacion'] = $variaciones;
    }

    $productos[$key]['calificacion'] = [];
    $calificacion = CalificacionProducto::mdlGetDetallesCalificacionProductoByIdUsuario($id_usuario, $producto['id_producto']);
    if ($calificacion != null) {
        $imagen_resena = json_decode($calificacion['imagen_resena']);

        $calificacion['imagen_resena'] = [];

        if($imagen_resena != null){
            $imagenes_resena = array();
            
            foreach ($imagen_resena as $key_imagen => $imagen) {
                $imagenes_resena[$key_imagen]['id_imagen'] = $imagen->id_imagen;
                $imagenes_resena[$key_imagen]['url_imagen'] = $url_servidor . $imagen->url_imagen;
            }
    
            $calificacion['imagen_resena'] = $imagenes_resena;
        }
        
        $productos[$key]['calificacion'] = $calificacion;
    }

}

$orden['total_precio_productos'] = $total_precio_productos;

$orden['productos'] = $productos;

$detalles_envios = GuiaEnvioOrden::mdlGetGuiaEnvioOrdenByIdOrden($id_orden);

$total_envio = 0;

foreach ($detalles_envios as $key_detalle_envio => $detalle_envio) {
    
    $orden['detalle_envio'][$key_detalle_envio]['numero_rastreo'] = $detalle_envio['numero_rastreo'];
    $orden['detalle_envio'][$key_detalle_envio]['fecha_orden'] = $detalle_envio['fecha_alta'];

    $guia_envio_producto = $detalle_envio['id_guia_envio_producto'];
    $precio_guia_envio_producto = GuiaEnvioProducto::mdlGetGuiaEnvioProductoById($guia_envio_producto);

    $orden['detalle_envio'][$key_detalle_envio]['nombre_paqueteria'] = $precio_guia_envio_producto['nombre'];
    
    if(!is_null($detalle_envio['numero_rastreo'])){
        switch($precio_guia_envio_producto['nombre'])
        {
            case 'DHL':
            case 'DHL EXPRESS':
                $orden['detalle_envio'][$key_detalle_envio]['url_paqueteria'] = 'https://www.dhl.com/mx-es/home/tracking/tracking-ecommerce.html?submit=1&tracking-id='.$detalle_envio['numero_rastreo'];
                break;
            
            case 'PAQUETEXPRESS':
                $orden['detalle_envio'][$key_detalle_envio]['url_paqueteria'] = 'https://www.paquetexpress.com.mx/rastreo/'.$detalle_envio['numero_rastreo'];
                break;
            
            case 'MTM':
                $orden['detalle_envio'][$key_detalle_envio]['url_paqueteria'] = '#';
                break;
        }
    }
    
    $total_envio += number_format((float)$precio_guia_envio_producto['precio'], 2, '.', '');
    
    if(!is_null($detalle_envio['id_guia_envio_zona_extendida_producto'])){
        $guia_envio_zona_extendida_producto = $detalle_envio['id_guia_envio_zona_extendida_producto'];

        $precio_guia_envio_zona_extendida_producto = GuiaEnvioZonaExtendidaProducto::mdllGetGuiaEnvioZonaExtendidaProductoById($guia_envio_zona_extendida_producto);

        $total_envio += number_format((float)$precio_guia_envio_zona_extendida_producto['precio'], 2, '.', '');
    }

}

$orden['total_envio'] = $total_envio;

$response['response'] = 'success';
$response['data'] = $orden;
echo json_encode($response);
