<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

// ini_set('display_errors', 1);
// ini_set('display_startup_errors', 1);
// error_reporting(E_ALL);

require '../../modelo/orden.php';
require '../../modelo/producto_orden.php';
require '../../modelo/environment.php';
// require '../pregunta/decodePregunta.php';

const LIMITE_DE_CLIENTES_POR_PAGINA = 20;

$numero_pagina = ($_POST['numero_pagina'] - 1);
$offset = $numero_pagina * LIMITE_DE_CLIENTES_POR_PAGINA;

$termino_busqueda = $_POST['termino_busqueda'];
$orderBy = json_decode($_POST['orderBy'], true);
$filters = json_decode($_POST['filters'], true);

$ordenes = Orden::mdlSearchLimit($filters, $termino_busqueda, $orderBy, $offset, LIMITE_DE_CLIENTES_POR_PAGINA);
$total_ordenes = Orden::mdlSearchTotal($filters, $termino_busqueda);

if (!$ordenes) {
    $response['response'] = 'error';
    $response['message'] = 'No se encontraron ordenes';
    echo json_encode($response);
    return;
}

foreach ($ordenes as $key => $orden) {

    // Aquí es donde agregas el nuevo código
    $productos_orden = ProductoOrden::mdlGetProductoOrdenByIdOrden($orden['id_orden']);
    $total = 0;
    if (!$productos_orden) {
        $response['response'] = 'error';
        $response['message'] = 'No se encontraron productos de la orden';
        echo json_encode($response);
        return;
    }

    foreach ($productos_orden as $key_producto_orden => $info_producto) {
        $ordenes[$key]['productos'][$key_producto_orden]['nombre'] = $info_producto['nombre'];

        $imagenes = json_decode($info_producto['imagenes']);
        $url_servidor = Environment::getUrlServidor();
        $ordenes[$key]['productos'][$key_producto_orden]['url_imagen'] = $url_servidor . $imagenes[0]->url;

        $ordenes[$key]['productos'][$key_producto_orden]['cantidad'] = $info_producto['cantidad'];
        $ordenes[$key]['productos'][$key_producto_orden]['precio'] = $info_producto['precio'];
        $ordenes[$key]['productos'][$key_producto_orden]['id_producto'] = $info_producto['id_producto'];
        $ordenes[$key]['productos'][$key_producto_orden]['color_categoria'] = $info_producto['color_categoria'];

        $total += $info_producto['cantidad'] * $info_producto['precio'];
    }
    $ordenes[$key]['total'] = $total;

    // Formateamos la fecha de la orden
    $fecha = date($orden['fecha_alta']);
    $fechaFormat = strftime("%B %d, %Y %H:%M", strtotime($fecha));
    $ordenes[$key]['fecha_alta'] = $fechaFormat;
}

$response['response'] = 'success';
$response['data'] = array(
    "ordenes" => $ordenes,
    "total_ordenes" => $total_ordenes['total'],
    "limite" => LIMITE_DE_CLIENTES_POR_PAGINA,
);

echo json_encode($response);
