<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/conexion.php';
require '../../modelo/material_extra.php';
require '../../modelo/environment.php';

$response = array();

if (!isset($_POST['id_producto'])) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_producto = $_POST['id_producto'];

$material_extra = MaterialExtra::mdlGetMaterialesExtraByIdProducto($id_producto);

if (!$material_extra) {
    $response['response'] = 'error';
    $response['data'] = 'No se encontraron materiales extras';
    echo json_encode($response);
    return;
}

foreach ($material_extra as $key => $value) {
    $fecha = date($value['fecha_alta']);
    $fechaFormat = strftime("%B %d, %Y %H:%M", strtotime($fecha));
    $material_extra[$key]['fecha_alta'] = $fechaFormat;
    
    $material_extra[$key]['url_pdf'] = Environment::getUrlServidor() . $value['url_pdf'];
}

$response['response'] = 'success';
$response['data'] = $material_extra;

echo json_encode($response);
