<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/conexion.php';
require '../../modelo/material_extra.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (!isset($_POST['id_material_extra'])) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_material_extra = $_POST['id_material_extra'];

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('material_extra', $id_material_extra));

$material_extra = MaterialExtra::mdlAddDescargaMaterialExtra($id_material_extra);

if (!$material_extra) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo incrementar las visitas del material extra';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'material_extra', $id_material_extra, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = true;

echo json_encode($response);