<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/guia_producto_orden.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_guia_producto_orden']) ||
    !isset($_POST['id_usuario'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_guia_producto_orden = $_POST['id_guia_producto_orden'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('guia_producto_orden', $id_guia_producto_orden));

$guia_producto_orden = GuiaProductoOrden::mdlDeleteGuiaProductoOrden($id_guia_producto_orden);

if (!$guia_producto_orden) {
    $response['response'] = 'error';
    $response['data'] = 'No se eliminó la guia_producto_orden';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('delete', 'guia_producto_orden', $id_guia_producto_orden, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = $guia_producto_orden;

echo json_encode($response);