<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/guia_producto_orden.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['id_paqueteria']) ||
    !isset($_POST['numero_rastreo'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_paqueteria = $_POST['id_paqueteria'];
$numero_rastreo = $_POST['numero_rastreo'];

$guia_producto_orden = GuiaProductoOrden::mdlAddGuiaProductoOrden($id_paqueteria, $numero_rastreo);

if (!$guia_producto_orden) {
    $response['response'] = 'error';
    $response['data'] = 'No se agregó la guia_producto_orden';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('create', 'guia_producto_orden', $guia_producto_orden, $id_usuario, NULL);

$response['response'] = 'success';
$response['data'] = $guia_producto_orden;

echo json_encode($response);