<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/formulario_contacto.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['visto']) ||
    !isset($_POST['id_formulario_contacto'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$visto = $_POST['visto'];
$id_formulario_contacto = $_POST['id_formulario_contacto'];
$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('formulario_contacto', $id_formulario_contacto));

$formulario_contacto = FormularioContacto::mdlUpdateVistoFormularioContacto($id_formulario_contacto,$visto);

if (!$formulario_contacto) {
    $response['response'] = 'error';
    $response['data'] = 'No se actualizó el estado visto del formulario de contacto';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'formulario_contacto', $id_formulario_contacto, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = $formulario_contacto;

echo json_encode($response);