<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/conexion.php';
require '../../modelo/faq.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/global.php';
require '../../modelo/history.php';

$response = array();

if (
    !isset($_POST['id_faq']) ||
    !isset($_POST['activo']) ||
    !isset($_POST['id_usuario'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_faq = $_POST['id_faq'];
$activo = $_POST['activo'];

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('faq', $id_faq));

$faq = Faq::mdlUpdateEstadoFaq($id_faq, $activo);

if (!$faq) {
    $response['response'] = 'error';
    $response['data'] = 'No se actualizó el estado de la FAQ';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'faq', $id_faq, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = true;

echo json_encode($response);