<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/conexion.php';
require '../../modelo/faq.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/global.php';
require '../../modelo/history.php';

$response = array();

if (!isset($_POST['id_faq']) || !isset($_POST['id_usuario'])) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_faq = $_POST['id_faq'];

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('faq', $id_faq));

$faq = Faq::mdlDeleteFaq($id_faq);

if (!$faq) {
    $response['response'] = 'error';
    $response['message'] = 'No se eliminó la FAQ';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('delete', 'faq', $id_faq, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = true;

echo json_encode($response);
