<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/faq.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['pregunta']) ||
    !isset($_POST['respuesta']) 
    // !isset($_POST['visitas']) ||
    // !isset($_POST['predeterminada'])
) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$pregunta = $_POST['pregunta'];
$respuesta = $_POST['respuesta'];
// $visitas = $_POST['visitas'];
// $predeterminada = $_POST['predeterminada'];

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$faq = Faq::mdlAddFaq($pregunta, $respuesta, 0, 0);

if (!$faq) {
    $response['response'] = 'error';
    $response['message'] = 'No se agregó la FAQ';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('add', 'faq', $faq, $id_usuario, NULL);

$response['response'] = 'success';
$response['data'] = $faq;

echo json_encode($response);