<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/estado_reclamo.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
$response = array();

if (
    !isset($_POST['id_estado_reclamo']) ||
    !isset($_POST['nombre']) ||
    !isset($_POST['descripcion']) ||
    !isset($_POST['activo'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_estado_reclamo = $_POST['id_estado_reclamo'];
$nombre = $_POST['nombre'];
$descripcion = $_POST['descripcion'];
$activo = $_POST['activo'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('estado_reclamo', $id_estado_reclamo));

$estado_reclamo = EstadoReclamo::mdlUpdateEstadoReclamo($id_estado_reclamo, $nombre, $descripcion, $activo);

if (!$estado_reclamo) {
    $response['response'] = 'error';
    $response['data'] = 'No se actualizó el estado de reclamo';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'estado_reclamo', $id_estado_reclamo, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = true;

echo json_encode($response);
