<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/direccion_facturacion.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['id_direccion_facturacion']) ||
    !isset($_POST['activo'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_direccion_facturacion = $_POST['id_direccion_facturacion'];
$activo = $_POST['activo'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('direccion_facturacion', $id_direccion_facturacion));

$direccion_facturacion = DireccionFacturacion::mdlUpdateEstadoDireccionFacturacion($id_usuario, $id_direccion_facturacion, $activo);

if (!$direccion_facturacion) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo actualizar el campo activo.';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'direccion_facturacion', $direccion_facturacion, $id_usuario, $valor_anterior);
$response['response'] = 'success';
$response['data'] = $direccion_facturacion;

echo json_encode($response);
return;