<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/direccion_facturacion.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/odoo_cliente.php';
require '../../modelo/history.php';
require '../../modelo/global.php';
require '../../modelo/usuario.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['id_direccion_facturacion'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';

    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {

    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';

    echo json_encode($response);
    return;
}

$id_direccion_facturacion = $_POST['id_direccion_facturacion'];

$valor_anterior = ModeloGlobal::mdlSelect('direccion_facturacion', $id_direccion_facturacion);

$id_usuario_odoo = intval(Usuario::mdlGetUsuarioIdOdoo($id_usuario));

$id_pais = OdooCliente::getIdMexicoCountry();
$id_estado_odoo = DireccionFacturacion::mdlGetIdEstadoOdoo($valor_anterior['estado']);

$calle_odoo = $valor_anterior['calle'] . ' ' . $valor_anterior['numero_exterior'];
if (strlen($valor_anterior['numero_interior']) > 0) {
    $calle_odoo .= ' Int: ' . $valor_anterior['numero_interior'];
}

$direccion_facturacion_odoo = OdooCliente::updateClientFacturacion(
    $id_usuario_odoo,
    $valor_anterior['numero_celular'],
    $valor_anterior['correo_facturacion'],
    $calle_odoo,
    $valor_anterior['colonia'],
    $valor_anterior['delegacion'],
    $valor_anterior['cp'],
    $valor_anterior['rfc'],
    $valor_anterior['razon_social'],
    intval($id_estado_odoo),
    $id_pais[0]
);

if (!$direccion_facturacion_odoo) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo actualizar la dirección de facturación en Odoo';
    echo json_encode($response);
    return;
}

$direccion_facturacion = DireccionFacturacion::mdlSetDireccionPredeterminada($id_usuario, $id_direccion_facturacion);

if (!$direccion_facturacion) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo establecer la dirección de facturación predeterminada';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'direccion_facturacion', $id_direccion_facturacion, $id_usuario, json_encode($valor_anterior));

$valor_nuevo = json_encode(ModeloGlobal::mdlSelect('direccion_facturacion', $id_direccion_facturacion));
ModeloHistory::mdlAddNewRegister('update', 'direccion_facturacion', $id_direccion_facturacion, $id_usuario, $valor_nuevo);

$response['response'] = 'success';
$response['data'] = $direccion_facturacion;

echo json_encode($response);
