<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/direccion_facturacion.php';
require '../../modelo/usuario.php';
require '../../modelo/direcciones_sepomex.php';
require '../../modelo/odoo_cliente.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';

$response = array();

if (
    !isset($_POST['razon_social']) ||
    !isset($_POST['rfc']) ||
    !isset($_POST['correo_facturacion']) ||
    !isset($_POST['id_regimen_fiscal']) ||
    !isset($_POST['nombre_regimen_fiscal']) ||
    !isset($_POST['id_uso_cfdi']) ||
    !isset($_POST['nombre_uso_cfdi']) ||
    !isset($_POST['cp']) ||
    !isset($_POST['id_usuario'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

// Necesitamos que la razon social este en mayusculas
$razon_social = $_POST['razon_social'];
$razon_social = mb_strtoupper($razon_social, 'UTF-8');

$rfc = strtoupper($_POST['rfc']);

$rfcPattern = '/^(?:[A-Za-z]{4}\d{6}[A-Za-z\d]{3}|[A-Za-z]{3}\d{6}[A-Za-z\d]{3})$/';

if (!preg_match($rfcPattern, $rfc)) {
    $response['response'] = 'error';
    $response['data'] = 'La estructura de RFC no es válida';
    echo json_encode($response);
    return;
}

$correo_facturacion = mb_strtolower($_POST['correo_facturacion'], 'UTF-8');
$id_regimen_fiscal = strval($_POST['id_regimen_fiscal']);
$nombre_regimen_fiscal = $_POST['nombre_regimen_fiscal'];
$id_uso_cfdi = strval($_POST['id_uso_cfdi']);
$nombre_uso_cfdi = $_POST['nombre_uso_cfdi'];
$cp = $_POST['cp'];
$estado = null;
$delegacion = null;
$colonia = null;
$calle = null;
$numero_exterior = null;
$numero_interior = null;
$numero_celular = null;
$calle_odoo = null;
$calle2_odoo = null;
$ciudad = null;
$id_estado_odoo = null;

$id_usuario_odoo = intval(Usuario::mdlGetUsuarioIdOdoo($id_usuario));

$id_pais = OdooCliente::getIdMexicoCountry();

$direccion_facturacion_odoo = OdooCliente::updateDatosFacturacion(
    $id_usuario_odoo,
    $correo_facturacion,
    $cp,
    $rfc,
    $razon_social,
    $id_pais[0],
    $id_regimen_fiscal,
    $id_uso_cfdi
);

if (!$direccion_facturacion_odoo) {
    $response['response'] = 'error';
    $response['data'] = 'No se actualizó la dirección de facturación en Odoo';
    echo json_encode($response);
    return;
}

$direccion_facturacion = DireccionFacturacion::mdlAddDireccionFacturacion(
    $id_usuario,
    $razon_social,
    $rfc,
    $correo_facturacion,
    $id_regimen_fiscal,
    $nombre_regimen_fiscal,
    $cp,
    $estado,
    $ciudad,
    $colonia,
    $calle,
    $numero_exterior,
    (!$numero_interior) ? NULL : $numero_interior,
    $numero_celular,
    $id_uso_cfdi,
    $nombre_uso_cfdi,
);

if (!$direccion_facturacion) {
    $response['response'] = 'error';
    $response['data'] = 'No se agregó la dirección de facturación';
    echo json_encode($response);
    return;
}

DireccionFacturacion::mdlSetDireccionPredeterminada($id_usuario, $direccion_facturacion);

$response['response'] = 'success';
$response['data'] = $direccion_facturacion;

echo json_encode($response);
