<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/direccion_envio.php';
require '../usuario/decodeUsuario.php';
$response = array();

if (
    !isset($_POST['id_usuario'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';

    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {

    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';

    echo json_encode($response);
    return;
}

$direcciones_envio = DireccionEnvio::mdlGetDireccionesById($id_usuario);

if (!$direcciones_envio) {
    $response['response'] = 'error';
    $response['data'] = [];
    echo json_encode($response);
    return;
}

$response['response'] = 'success';
$response['data'] = $direcciones_envio;

echo json_encode($response);