<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/direccion_envio.php';
require '../usuario/decodeUsuario.php';
$response = array();

if (
    isset($_POST['id_usuario']) &&
    isset($_POST['id_direccion'])
) {
    $id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

    if (!$id_usuario) {

        $response['response'] = 'error';
        $response['data'] = 'Id del usuario incorrecto.';

        echo json_encode($response);
        return;
    }
    
    $id_direccion = $_POST['id_direccion'];

    $direccion_envio = DireccionEnvio::mdlGetDireccionById($id_usuario, $id_direccion);

    if (!$direccion_envio) {
        $response['response'] = 'error';
        $response['data'] = 'No se encontró la dirección de envío';
    } else {
        $response['response'] = 'success';
        $response['data'] = $direccion_envio;
    }

    echo json_encode($response);
    return;
} else {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';

    echo json_encode($response);
    return;
}
