<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/direccion_envio.php';
require '../usuario/decodeUsuario.php';

$response = array();

if (
    !isset($_POST['cp']) ||
    !isset($_POST['estado']) ||
    !isset($_POST['delegacion']) ||
    !isset($_POST['colonia']) ||
    !isset($_POST['calle']) ||
    !isset($_POST['numero_exterior']) ||
    !isset($_POST['numero_celular']) ||
    !isset($_POST['referencia']) ||
    !isset($_POST['nombre_receptor'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$cp = $_POST['cp'];
$estado = $_POST['estado'];
$delegacion = $_POST['delegacion'];
$colonia = $_POST['colonia'];
$calle = $_POST['calle'];
$numero_exterior = $_POST['numero_exterior'];
$numero_interior = $_POST['numero_interior'];
$numero_celular = $_POST['numero_celular'];
$referencia = $_POST['referencia'];
$nombre_receptor = $_POST['nombre_receptor'];

$direccion_envio = DireccionEnvio::mdlAddDireccion(
    $id_usuario,
    $cp,
    $estado,
    $delegacion,
    $colonia,
    $calle,
    $numero_exterior,
    (!$numero_interior) ? NULL : $numero_interior,
    $numero_celular,
    $referencia,
    $nombre_receptor,
);

if (!$direccion_envio) {
    $response['response'] = 'error';
    $response['data'] = 'No se agregó la dirección de envío';
    return;
}

DireccionEnvio::mdlSetDireccionPredeterminada($id_usuario, $direccion_envio);

$response['response'] = 'success';
$response['data'] = $direccion_envio;

echo json_encode($response);