<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/orden.php';
require '../../modelo/producto_orden.php';
require '../../modelo/pago.php';
require '../../modelo/environment.php';
require '../usuario/decodeUsuario.php';
$response = array();

if (!isset($_POST['id'])) {
    $response['response'] = 'error';
    echo json_encode($response);
    return;
}

// 0. Validamos que sea un usuario autorizado por nuestro servidor para leer la información
$id_usuario = DecodeUser::handlePostUsuario($_POST['id']);
if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario no válido';
    echo json_encode($response);
    return;
}

$limite = 10;
$ordenes = Orden::mdlGetUltimasOrdenesLimit($limite);

if (!$ordenes) {
    $response['response'] = 'error';
    $response['message'] = 'No se encontraron ordenes';
    echo json_encode($response);
    return;
}

foreach ($ordenes as $key => $orden) {

    // Aquí es donde agregas el nuevo código
    $productos_orden = ProductoOrden::mdlGetProductoOrdenByIdOrden($orden['id_orden']);
    $total = 0;
    if (!$productos_orden) {
        $response['response'] = 'error';
        $response['message'] = 'No se encontraron productos de la orden';
        echo json_encode($response);
        return;
    }

    foreach ($productos_orden as $key_producto_orden => $info_producto) {
        $ordenes[$key]['productos'][$key_producto_orden]['nombre'] = $info_producto['nombre'];

        $imagenes = json_decode($info_producto['imagenes']);
        $url_servidor = Environment::getUrlServidor();
        $ordenes[$key]['productos'][$key_producto_orden]['url_imagen'] = $url_servidor . $imagenes[0]->url;

        $ordenes[$key]['productos'][$key_producto_orden]['cantidad'] = $info_producto['cantidad'];
        $ordenes[$key]['productos'][$key_producto_orden]['precio'] = $info_producto['precio'];
        $ordenes[$key]['productos'][$key_producto_orden]['id_producto'] = $info_producto['id_producto'];
        $ordenes[$key]['productos'][$key_producto_orden]['color_categoria'] = $info_producto['color_categoria'];

        $total += $info_producto['cantidad'] * $info_producto['precio'];
    }
    $ordenes[$key]['total'] = $total;

    // Formateamos la fecha de la orden
    $fecha = date($orden['fecha_alta']);
    $fechaFormat = strftime("%B %d, %Y %H:%M", strtotime($fecha));
    $ordenes[$key]['fecha_alta'] = $fechaFormat;
}

$response['response'] = 'success';
$response['data'] = $ordenes;
echo json_encode($response);
