<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/conexion.php';
require '../../modelo/red_social.php';
require '../../modelo/datos_contacto.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/global.php';
require '../../modelo/history.php';

$response = array();

if (
    !isset($_POST['correo']) ||
    !isset($_POST['telefono']) ||
    !isset($_POST['id_usuario'])
) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$correo = $_POST['correo'];
$telefono = $_POST['telefono'];

// ACTUALIZAMOS EL CORREO
$id_datos_contacto_correo = 1;
$valor_anterior = json_encode(ModeloGlobal::mdlSelect('datos_contacto', $id_datos_contacto_correo));
$update_correo = DatosContacto::mdlUpdateDatoContacto("correo", $correo);

if ($update_correo) {
    ModeloHistory::mdlAddNewRegister('update', 'datos_contacto', $id_datos_contacto_correo, $id_usuario, $valor_anterior);
}


// ACTUALIZAMOS EL TELEFONO
$id_datos_contacto_telefono = 2;
$valor_anterior = json_encode(ModeloGlobal::mdlSelect('datos_contacto', $id_datos_contacto_telefono));
$update_telefono = DatosContacto::mdlUpdateDatoContacto("telefono", $telefono);

if ($update_telefono) {
    ModeloHistory::mdlAddNewRegister('update', 'datos_contacto', $id_datos_contacto_telefono, $id_usuario, $valor_anterior);
}


// ACTUALIZAMOS LAS REDES SOCIALES
// Verificar si la red social tiene el mismo dato que el anterior
// Si es así, no se actualiza
$url_facebook = $_POST['url_facebook'];
$data_facebook = RedSocial::mdlGetRedSocialByName("Facebook");
$url_facebook_actual = $data_facebook['url'];
$id_red_social_facebook = $data_facebook['id_red_social'];

// Si no son iguales, se actualiza
// FACEBOOK
if ($url_facebook != $url_facebook_actual) {
    $valor_anterior = json_encode(ModeloGlobal::mdlSelect('red_social', $id_red_social_facebook));
    $activo = ($url_facebook == '') ? 0 : 1;
    $url_final = ($url_facebook == '') ? NULL : $url_facebook;
    $update_facebook = RedSocial::mdlUpdateRedSocialByNombre("Facebook", $url_final, $activo);
    if ($update_facebook) {
        ModeloHistory::mdlAddNewRegister('update', 'red_social', $id_red_social_facebook, $id_usuario, $valor_anterior);
    }
}

// INSTAGRAM
$url_instagram = $_POST['url_instagram'];
$data_instagram = RedSocial::mdlGetRedSocialByName("Instagram");
$url_instagram_actual = $data_instagram['url'];
$id_red_social_instagram = $data_instagram['id_red_social'];

if ($url_instagram != $url_instagram_actual) {
    $valor_anterior = json_encode(ModeloGlobal::mdlSelect('red_social', $id_red_social_instagram));
    $activo = ($url_instagram == '') ? 0 : 1;
    $url_final = ($url_instagram == '') ? NULL : $url_instagram;
    $update_instagram = RedSocial::mdlUpdateRedSocialByNombre("Instagram", $url_final, $activo);
    if ($update_instagram) {
        ModeloHistory::mdlAddNewRegister('update', 'red_social', $id_red_social_instagram, $id_usuario, $valor_anterior);
    }
}


// PINTEREST
$url_pinterest = $_POST['url_pinterest'];
$data_pinterest = RedSocial::mdlGetRedSocialByName("Pinterest");
$url_pinterest_actual = $data_pinterest['url'];
$id_red_social_pinterest = $data_pinterest['id_red_social'];

if ($url_pinterest != $url_pinterest_actual) {
    $valor_anterior = json_encode(ModeloGlobal::mdlSelect('red_social', $id_red_social_pinterest));
    $activo = ($url_pinterest == '') ? 0 : 1;
    $url_final = ($url_pinterest == '') ? NULL : $url_pinterest;
    $update_pinterest = RedSocial::mdlUpdateRedSocialByNombre("Pinterest", $url_final, $activo);
    if ($update_pinterest) {
        ModeloHistory::mdlAddNewRegister('update', 'red_social', $id_red_social_pinterest, $id_usuario, $valor_anterior);
    }
}

// WHATSAPP
$url_whatsapp = $_POST['url_whatsapp'];
$data_whatsapp = RedSocial::mdlGetRedSocialByName("WhatsApp");
$url_whatsapp_actual = $data_whatsapp['url'];
$id_red_social_whatsapp = $data_whatsapp['id_red_social'];

if ($url_whatsapp != $url_whatsapp_actual) {
    $valor_anterior = json_encode(ModeloGlobal::mdlSelect('red_social', $id_red_social_whatsapp));
    $activo = ($url_whatsapp == '') ? 0 : 1;
    $url_final = ($url_whatsapp == '') ? NULL : $url_whatsapp;
    $update_whatsapp = RedSocial::mdlUpdateRedSocialByNombre("WhatsApp", $url_final, $activo);
    if ($update_whatsapp) {
        ModeloHistory::mdlAddNewRegister('update', 'red_social', $id_red_social_whatsapp, $id_usuario, $valor_anterior);
    }
}

$response['response'] = 'success';
$response['data'] = true;

echo json_encode($response);
