<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/cita_soporte_tecnico.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/global.php';
require '../../modelo/history.php';
$response = array();

if (
    !isset($_POST['id_cita_soporte_tecnico']) ||
    !isset($_POST['activo'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_cita_soporte_tecnico = $_POST['id_cita_soporte_tecnico'];
$activo = $_POST['activo'];

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('cita_soporte_tecnico', $id_cita_soporte_tecnico));

$cita_soporte_tecnico = CitaSoporteTecnico::mdlUpdateActivoCitaSoporteTecnico($id_cita_soporte_tecnico, $activo);

if (!$cita_soporte_tecnico) {
    $response['response'] = 'error';
    $response['data'] = 'No se actualizó el estado de la cita de soporte técnico';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'cita_soporte_tecnico', $id_cita_soporte_tecnico, $id_usuario, $valor_anterior);

$response['response'] = 'success';
$response['data'] = true;

echo json_encode($response);