<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/cita_soporte_tecnico.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/global.php';
require '../../modelo/history.php';
$response = array();

if (
    !isset($_POST['id_cita_soporte_tecnico']) ||
    !isset($_POST['id'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id = DecodeUser::handlePostUsuario($_POST['id']);

if (!$id) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_cita_soporte_tecnico = $_POST['id_cita_soporte_tecnico'];
$id_estado_cita = 4; // <--- Este id_estado_cita es de "Cancelar" en la BD

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('cita_soporte_tecnico', $id_cita_soporte_tecnico));

$cita_soporte_tecnico = CitaSoporteTecnico::mdlUpdateEstadoCita($id_cita_soporte_tecnico, $id_estado_cita);

if (!$cita_soporte_tecnico) {
    $response['response'] = 'error';
    $response['message'] = 'No se actualizó el estado de la cita de soporte técnico';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'cita_soporte_tecnico', $id_cita_soporte_tecnico, $id, $valor_anterior);

$response['response'] = 'success';
$response['data'] = true;

echo json_encode($response);