<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('error_reporting', E_ALL);
require '../../modelo/cita_soporte_tecnico.php';
require '../../modelo/pago_soporte_tecnico.php';

const LIMITE_DE_CLIENTES_POR_PAGINA = 20;

$numero_pagina = ($_POST['numero_pagina'] - 1);
$offset = $numero_pagina * LIMITE_DE_CLIENTES_POR_PAGINA;

$termino_busqueda = $_POST['termino_busqueda'];
$orderBy = json_decode($_POST['orderBy'], true);
$filters = json_decode($_POST['filters'], true);

$tickets_soporte = CitaSoporteTecnico::mdlSearchLimit($filters, $termino_busqueda, $orderBy, $offset, LIMITE_DE_CLIENTES_POR_PAGINA);
$total_tickets_soporte = CitaSoporteTecnico::mdlSearchTotal($filters, $termino_busqueda);

if (!$tickets_soporte) {
    $response['response'] = 'error';
    $response['message'] = 'No se encontraron tickets soporte';
    echo json_encode($response);
    return;
}

foreach ($tickets_soporte as $key => $ticket_soporte) {
    $tickets_soporte[$key]['nombre_completo'] = $ticket_soporte['nombre_cliente'] . ' ' . $ticket_soporte['apellido_paterno_cliente'] . ' ' . $ticket_soporte['apellido_materno_cliente'];
    $fecha = date($ticket_soporte['fecha_alta']);
    $fechaFormat = strftime("%B %d, %Y %H:%M", strtotime($fecha));
    $tickets_soporte[$key]['fecha_alta'] = $fechaFormat;
    
    // separar fecha y hora
    $fecha = explode(' ', $ticket_soporte['fecha_hora']);
    $fechaFormat = strftime("%B %d, %Y %H:%M", strtotime($fecha[0]));
    // concatenar la hora a la fecha y quitar segundos de la hora al final
    $fechaFormat = $fechaFormat . ', ' . $fecha[1];
    $fechaFormat = substr($fechaFormat, 0, -3);
    $tickets_soporte[$key]['fecha_hora'] = $fechaFormat;

    // Obtenemos la información del pago de la cita
    $id_cita_soporte_tecnico = $ticket_soporte['id_cita_soporte_tecnico'];
    $data_pago = PagoSoporteTecnico::mdlGetPagoByIdCita($id_cita_soporte_tecnico);
    $cantidad_pago = (!$data_pago) ? null : $data_pago['cantidad_pago'];
    $id_transaccion = (!$data_pago) ? null : $data_pago['id_transaccion'];

    $tickets_soporte[$key]['cantidad_pago'] = $cantidad_pago;
    $tickets_soporte[$key]['id_transaccion'] = $id_transaccion;
    
    // Verificamos si todavía aplica el soporte tecnico
    if(!$data_pago){
        // Si no hay pago, significa que se hizo una cita de un producto con is_soporte_tecnico = 1
        // Asi que verificamos si todavía aplica la garantía, tomando de referencia la fecha de compra
        $fecha_compra = strtotime($ticket_soporte['fecha_compra']);
        $is_soporte_tecnico = $ticket_soporte['is_soporte_tecnico'];
        $tiempo_garantia = $ticket_soporte['tiempo_garantia'];
        $fecha_limite_garantia = strtotime("+$tiempo_garantia years", $fecha_compra);
        $fecha_actual = strtotime(date('Y-m-d'));
        $tickets_soporte[$key]['is_garantia'] = (($fecha_actual <= $fecha_limite_garantia) && $is_soporte_tecnico == "1") ? true : false;
        // $tickets_soporte[$key]['fecha_compra'] = date('d-m-Y', $fecha_compra);
        $tickets_soporte[$key]['fecha_compra'] = strftime("%B %d %Y",$fecha_compra);
        // $tickets_soporte[$key]['fecha_limite_garantia'] = date('d-m-Y', $fecha_limite_garantia);
        $tickets_soporte[$key]['fecha_limite_garantia'] = strftime("%B %d %Y",$fecha_limite_garantia);
    } else {
        // Si ya hay un pago, de entrada sabemos que no aplico la garantía
        $tickets_soporte[$key]['is_garantia'] = false;
        $tickets_soporte[$key]['fecha_compra'] = null;
        $tickets_soporte[$key]['fecha_limite_garantia'] = null;
    }
}

$response['response'] = 'success';
$response['data'] = array(
    "tickets_soporte" => $tickets_soporte,
    "total_tickets_soporte" => $total_tickets_soporte['total'],
    "limite" => LIMITE_DE_CLIENTES_POR_PAGINA,
);

echo json_encode($response);