<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

// error_reporting(E_ALL);
// ini_set('display_errors', 1);
// ini_set('error_reporting', E_ALL);

require '../../modelo/cita_soporte_tecnico.php';
require '../../modelo/openpay.php';
require '../../modelo/pago_soporte_tecnico.php';
require '../usuario/decodeUsuario.php';
$response = array();

function generarIdentificador($numero_caracteres = 10)
{
    $characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
    $numero_ticket = 'S-';
    for ($i = 0; $i < $numero_caracteres; $i++) {
        $random_character = $characters[rand(0, strlen($characters) - 1)];
        $numero_ticket .= $random_character;
    }
    return $numero_ticket;
}

if (
    !isset($_POST['id_tipo_soporte_tecnico']) ||
    !isset($_POST['fecha_hora'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$numero_ticket = generarIdentificador();

if(CitaSoporteTecnico::mdlVerifyNumeroTicket($numero_ticket)){
    $numero_ticket = generarIdentificador();
}

$id_tipo_soporte_tecnico = $_POST['id_tipo_soporte_tecnico'];
$fecha_hora = $_POST['fecha_hora'];
$id_producto_orden = strlen($_POST['id_producto_orden']) > 0 ? $_POST['id_producto_orden'] : null;
$id_marca = strlen($_POST['id_marca']) > 0 ? $_POST['id_marca'] : null;
$modelo_producto = strlen($_POST['modelo_producto']) > 0 ? $_POST['modelo_producto'] : null;
$numero_serie = strlen($_POST['numero_serie']) > 0 ? $_POST['numero_serie'] : null;
$observaciones = strlen($_POST['observaciones']) > 0 ? $_POST['observaciones'] : null;
$id_transaccion = strlen($_POST['id_transaccion']) > 0 ? $_POST['id_transaccion'] : null;

$cita_soporte_tecnico = CitaSoporteTecnico::mdlAddCitaSoporteTecnico($id_usuario, $id_tipo_soporte_tecnico, $fecha_hora, $numero_ticket, $id_producto_orden, $id_marca, $modelo_producto, $numero_serie, $observaciones);

if (!$cita_soporte_tecnico) {
    $response['response'] = 'error';
    $response['data'] = 'No se agregó la cita de soporte técnico';
    echo json_encode($response);
    return;
}

if(!is_null($id_transaccion)) {
    $openpay = OpenpayAuth::getOpenpayConexion();
    
    if(!$openpay) {
        $response['response'] = 'error';
        $response['data'] = 'Error al conectar con Openpay.';
        echo json_encode($response);
        return;
    }
    
    $charge = $openpay->charges->get($id_transaccion);
    
    // Payment method
    $metodo_pago = $charge->card->type;
    
    // Currency
    $moneda = $charge->currency;
    
    // Payment amount
    $cantidad_pago = $charge->amount;
    
    // Buyer's name
    $nombre_comprador = $charge->card->holder_name;
    
    // Buyer's email 
    $correo = $charge->customer->email;
    // Payment status
    $estado_pago = $charge->status;
    
    $ip = $_SERVER['REMOTE_ADDR'];
    // $ip = "192.168.1.1";
    
    $details = json_decode(file_get_contents("http://www.geoplugin.net/json.gp?ip={$ip}"));
    $pais = $details->geoplugin_countryCode;
    // $pais = "MX";
    
    $user_agent = $_SERVER['HTTP_USER_AGENT'];
    // $user_agent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36";
    
    $pago = PagoSoporteTecnico::mdlAddPagoCitaSoporteTecnico($cita_soporte_tecnico, $id_transaccion, 'openpay', $metodo_pago, $moneda, $cantidad_pago, $nombre_comprador, $correo, $estado_pago, $user_agent, $ip);

}

$response['response'] = 'success';
$response['data'] = $cita_soporte_tecnico;

echo json_encode($response);