<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/categoria.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['id_categoria']) ||
    !isset($_POST['activo'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_categoria = $_POST['id_categoria'];
$activo = $_POST['activo'];
$valor_anterior = json_encode(ModeloGlobal::mdlSelect('categoria', $id_categoria));

$categoria = Categoria::mdlUpdateActivoCategoria($id_categoria, $activo);

if (!$categoria) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo actualizar el campo activo.';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('update', 'categoria', $categoria, $id_usuario, $valor_anterior);
$response['response'] = 'success';
$response['data'] = $categoria;

echo json_encode($response);
return;