<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/categoria.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
require '../../modelo/global.php';

$response = array();

if (!isset(
    $_POST['id_usuario'],
    $_POST['id_categoria']
)) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

if (!isset($_FILES['imagen']['name'])) {
    $response['response'] = 'error';
    $response['data'] = 'No hay imagen';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {
    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';
    echo json_encode($response);
    return;
}

$id_categoria = $_POST['id_categoria'];

$imagen = $_FILES['imagen']['name'];

$extension = pathinfo($imagen, PATHINFO_EXTENSION);
$nombreImagen = uniqid() . "-" . $id_categoria . '.' . $extension;

$imagenRuta = '../../asset/img/categoria/' . $nombreImagen;

$valor_anterior = json_encode(ModeloGlobal::mdlSelect('categoria', $id_categoria));

if (!move_uploaded_file($_FILES['imagen']['tmp_name'], $imagenRuta)) {
    $response['response'] = 'error';
    $response['data'] = 'No se pudo subir la imagen';
    echo json_encode($response);
    return;
}

if (Categoria::mdlUpdateCategoriaImagen($id_categoria, $nombreImagen)) {
    ModeloHistory::mdlAddNewRegister('update', 'categoria', $id_categoria, $id_usuario, $valor_anterior);
    $response['response'] = 'success';
    $response['data'] = true;
    echo json_encode($response);
    return;
}