<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/categoria.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['nombre']) ||
    !isset($_POST['descripcion']) ||
    !isset($_POST['url_pagina']) ||
    !isset($_POST['color'])
) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';

    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {

    $response['response'] = 'error';
    $response['data'] = 'Id del usuario incorrecto.';

    echo json_encode($response);
    return;
}

$nombre = $_POST['nombre'];
$descripcion = $_POST['descripcion'];
$url_pagina = $_POST['url_pagina'];
$color = $_POST['color'];

$categoria = Categoria::mdlAddCategoria($nombre, $descripcion, $url_pagina, $color);

if (!$categoria) {
    $response['response'] = 'error';
    $response['data'] = 'No se agregó la categoria';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('create', 'categoria', $categoria, $id_usuario, NULL);

$response['response'] = 'success';
$response['data'] = $categoria;

echo json_encode($response);