<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/catalogo.php';
require '../../modelo/environment.php';
$response = array();

$catalogos = Catalogo::mdlGetAllCatalogos();

if (!$catalogos) {
    $response['response'] = 'error';
    $response['message'] = 'No se encontraron catalogos';
    echo json_encode($response);
    return;
}

foreach ($catalogos as $key => $banner) {
    $catalogos[$key]['imagen_portada'] = Environment::getUrlServidor() . $banner['imagen_portada'];
    $catalogos[$key]['link_pdf'] = Environment::getUrlServidor() . $banner['link_pdf'];
}

$response['response'] = 'success';
$response['data'] = $catalogos;

echo json_encode($response);
