<?php

// header('Access-Control-Allow-Origin: *');
// header('Access-Control-Allow-Headers: *');

// require '../../modelo/catalogo.php';
// require '../usuario/decodeUsuario.php';
// require '../../modelo/history.php';

// $response = array();

// if (
//     isset($_POST['id_usuario']) &&
//     isset($_POST['nombre']) &&
//     isset($_POST['descripcion']) &&
//     isset($_POST['imagen_portada']) &&
//     isset($_POST['link_pdf'])
// ) {

//     $id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

//     if (!$id_usuario) {

//         $response['response'] = 'error';
//         $response['data'] = 'Id del usuario incorrecto.';

//         echo json_encode($response);
//         return;
//     }

//     $nombre = $_POST['nombre'];
//     $descripcion = $_POST['descripcion'];
//     $imagen_portada = $_POST['imagen_portada'];
//     $link_pdf = $_POST['link_pdf'];

//     $catalogo = Catalogo::mdlAddCatalogo($nombre, $descripcion, $imagen_portada, $link_pdf);

//     if (!$catalogo) {
//         $response['response'] = 'error';
//         $response['data'] = 'No se agregó el item al catálogo';
//     } else {

//         ModeloHistory::mdlAddNewRegister('create', 'catalogo', $catalogo, $id_usuario, NULL);

//         $response['response'] = 'success';
//         $response['data'] = $catalogo;
//     }

//     echo json_encode($response);
//     return;
// } else {
//     $response['response'] = 'error';
//     $response['data'] = 'Datos incompletos';

//     echo json_encode($response);
//     return;
// }


header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/catalogo.php';
require '../usuario/decodeUsuario.php';
require '../../modelo/history.php';
$response = array();

if (
    !isset($_POST['id_usuario']) ||
    !isset($_POST['nombre']) ||
    !isset($_POST['descripcion']) 
    // !isset($_POST['imagen_portada']) ||
    // !isset($_POST['link_pdf']) ||
    // !isset($_POST['orden'])
) {
    $response['response'] = 'error';
    $response['message'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$id_usuario = DecodeUser::handlePostUsuario($_POST['id_usuario']);

if (!$id_usuario) {

    $response['response'] = 'error';
    $response['message'] = 'Id del usuario incorrecto.';

    echo json_encode($response);
    return;
}

$nombre = $_POST['nombre'];
$descripcion = !isset($_POST['descripcion']) ? NULL : $_POST['descripcion'];
$imagen_portada = !isset($_POST['imagen_portada']) ? NULL : $_POST['imagen_portada'];
$link_pdf = !isset($_POST['link_pdf']) ? NULL : $_POST['link_pdf'];
$orden = NULL;

$last_catalogo = Catalogo::mdlGetLastCatalogoOrder();
$orden = intval($last_catalogo['orden']) + 1;

$catalogo = Catalogo::mdlAddCatalogo($nombre, $descripcion, $imagen_portada, $link_pdf, $orden);

if (!$catalogo) {
    $response['response'] = 'error';
    $response['message'] = 'No se agregó el catálogo';
    echo json_encode($response);
    return;
}

ModeloHistory::mdlAddNewRegister('create', 'catalogo', $catalogo, $id_usuario, NULL);

$response['response'] = 'success';
$response['data'] = $catalogo;

echo json_encode($response);
return;
