<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: *');

require '../../modelo/odoo_inventario.php';
require '../../modelo/almacenes_odoo.php';
require '../../modelo/producto.php';
require '../../modelo/producto_variacion.php';

$response = array();
$productos = array();

if (!isset($_POST['url_pagina'])) {
    $response['response'] = 'error';
    $response['data'] = 'Datos incompletos';
    echo json_encode($response);
    return;
}

$url_pagina = $_POST['url_pagina'];

$id_producto = Producto::mdlGetProductoByURL($url_pagina);

$is_producto_variable = ProductoVariacion::mdlGetProductoVariacionByIdProductoPadre($id_producto['id_producto']);

// $productos[0]['id_producto_odoo'] = intval($id_producto['id_producto_odoo']);
// $productos[]['id_producto_odoo'] = intval($id_producto['id_producto_odoo']);

if ($is_producto_variable != false) {
    foreach ($is_producto_variable as $key => $producto) {
        $id_producto_odoo = Producto::mdlGetIdProductoOdoo($producto['id_producto']);
        $productos[$key]['id_producto_odoo'] = intval($id_producto_odoo['id_producto_odoo']);
    }
} else {
    $productos[]['id_producto_odoo'] = intval($id_producto['id_producto_odoo']);
}

$product_ids = [];

foreach ($productos as $item) {
    // $product_ids[] = intval($item['id_producto_odoo']);
    $product_ids[] = intval($item['id_producto_odoo']);
}

$almacenes_odoo = AlmacenesOdoo::mdlGetIdAlmacenesOdoo();
// echo json_encode($item);
// return;
$warehouse_ids = [];

foreach ($almacenes_odoo as $item) {
    $warehouse_ids[] = intval($item['id_odoo']);
}

$stocks = OdooInventario::getGlobalStock($product_ids, $warehouse_ids);

$response['response'] = 'success';
$response['data'] = $stocks;
echo json_encode($stocks);
